import { __ } from '@wordpress/i18n';

/**
 * Translated country names for internationalization.
 * This provides human-readable, translatable country names
 * that can be used alongside the country-list.js data.
 */
export const translatedCountryNames = {
	AF: __( 'Afghanistan', 'jetpack-forms' ),
	AL: __( 'Albania', 'jetpack-forms' ),
	DZ: __( 'Algeria', 'jetpack-forms' ),
	AS: __( 'American Samoa', 'jetpack-forms' ),
	AD: __( 'Andorra', 'jetpack-forms' ),
	AO: __( 'Angola', 'jetpack-forms' ),
	AI: __( 'Anguilla', 'jetpack-forms' ),
	AG: __( 'Antigua and Barbuda', 'jetpack-forms' ),
	AR: __( 'Argentina', 'jetpack-forms' ),
	AM: __( 'Armenia', 'jetpack-forms' ),
	AW: __( 'Aruba', 'jetpack-forms' ),
	AU: __( 'Australia', 'jetpack-forms' ),
	AT: __( 'Austria', 'jetpack-forms' ),
	AZ: __( 'Azerbaijan', 'jetpack-forms' ),
	BS: __( 'Bahamas', 'jetpack-forms' ),
	BH: __( 'Bahrain', 'jetpack-forms' ),
	BD: __( 'Bangladesh', 'jetpack-forms' ),
	BB: __( 'Barbados', 'jetpack-forms' ),
	BY: __( 'Belarus', 'jetpack-forms' ),
	BE: __( 'Belgium', 'jetpack-forms' ),
	BZ: __( 'Belize', 'jetpack-forms' ),
	BJ: __( 'Benin', 'jetpack-forms' ),
	BM: __( 'Bermuda', 'jetpack-forms' ),
	BT: __( 'Bhutan', 'jetpack-forms' ),
	BO: __( 'Bolivia', 'jetpack-forms' ),
	BA: __( 'Bosnia and Herzegovina', 'jetpack-forms' ),
	BW: __( 'Botswana', 'jetpack-forms' ),
	BR: __( 'Brazil', 'jetpack-forms' ),
	IO: __( 'British Indian Ocean Territory', 'jetpack-forms' ),
	VG: __( 'British Virgin Islands', 'jetpack-forms' ),
	BN: __( 'Brunei', 'jetpack-forms' ),
	BG: __( 'Bulgaria', 'jetpack-forms' ),
	BF: __( 'Burkina Faso', 'jetpack-forms' ),
	BI: __( 'Burundi', 'jetpack-forms' ),
	KH: __( 'Cambodia', 'jetpack-forms' ),
	CM: __( 'Cameroon', 'jetpack-forms' ),
	CA: __( 'Canada', 'jetpack-forms' ),
	CV: __( 'Cape Verde', 'jetpack-forms' ),
	KY: __( 'Cayman Islands', 'jetpack-forms' ),
	CF: __( 'Central African Republic', 'jetpack-forms' ),
	TD: __( 'Chad', 'jetpack-forms' ),
	CL: __( 'Chile', 'jetpack-forms' ),
	CN: __( 'China', 'jetpack-forms' ),
	CX: __( 'Christmas Island', 'jetpack-forms' ),
	CC: __( 'Cocos (Keeling) Islands', 'jetpack-forms' ),
	CO: __( 'Colombia', 'jetpack-forms' ),
	KM: __( 'Comoros', 'jetpack-forms' ),
	CG: __( 'Congo - Brazzaville', 'jetpack-forms' ),
	CD: __( 'Congo - Kinshasa', 'jetpack-forms' ),
	CK: __( 'Cook Islands', 'jetpack-forms' ),
	CR: __( 'Costa Rica', 'jetpack-forms' ),
	HR: __( 'Croatia', 'jetpack-forms' ),
	CU: __( 'Cuba', 'jetpack-forms' ),
	CY: __( 'Cyprus', 'jetpack-forms' ),
	CZ: __( 'Czech Republic', 'jetpack-forms' ),
	CI: __( "Côte d'Ivoire", 'jetpack-forms' ),
	DK: __( 'Denmark', 'jetpack-forms' ),
	DJ: __( 'Djibouti', 'jetpack-forms' ),
	DM: __( 'Dominica', 'jetpack-forms' ),
	DO: __( 'Dominican Republic', 'jetpack-forms' ),
	EC: __( 'Ecuador', 'jetpack-forms' ),
	EG: __( 'Egypt', 'jetpack-forms' ),
	SV: __( 'El Salvador', 'jetpack-forms' ),
	GQ: __( 'Equatorial Guinea', 'jetpack-forms' ),
	ER: __( 'Eritrea', 'jetpack-forms' ),
	EE: __( 'Estonia', 'jetpack-forms' ),
	SZ: __( 'Eswatini', 'jetpack-forms' ),
	ET: __( 'Ethiopia', 'jetpack-forms' ),
	FK: __( 'Falkland Islands', 'jetpack-forms' ),
	FO: __( 'Faroe Islands', 'jetpack-forms' ),
	FJ: __( 'Fiji', 'jetpack-forms' ),
	FI: __( 'Finland', 'jetpack-forms' ),
	FR: __( 'France', 'jetpack-forms' ),
	GF: __( 'French Guiana', 'jetpack-forms' ),
	PF: __( 'French Polynesia', 'jetpack-forms' ),
	GA: __( 'Gabon', 'jetpack-forms' ),
	GM: __( 'Gambia', 'jetpack-forms' ),
	GE: __( 'Georgia', 'jetpack-forms' ),
	DE: __( 'Germany', 'jetpack-forms' ),
	GH: __( 'Ghana', 'jetpack-forms' ),
	GI: __( 'Gibraltar', 'jetpack-forms' ),
	GR: __( 'Greece', 'jetpack-forms' ),
	GL: __( 'Greenland', 'jetpack-forms' ),
	GD: __( 'Grenada', 'jetpack-forms' ),
	GP: __( 'Guadeloupe', 'jetpack-forms' ),
	GU: __( 'Guam', 'jetpack-forms' ),
	GT: __( 'Guatemala', 'jetpack-forms' ),
	GG: __( 'Guernsey', 'jetpack-forms' ),
	GN: __( 'Guinea', 'jetpack-forms' ),
	GW: __( 'Guinea-Bissau', 'jetpack-forms' ),
	GY: __( 'Guyana', 'jetpack-forms' ),
	HT: __( 'Haiti', 'jetpack-forms' ),
	HN: __( 'Honduras', 'jetpack-forms' ),
	HK: __( 'Hong Kong', 'jetpack-forms' ),
	HU: __( 'Hungary', 'jetpack-forms' ),
	IS: __( 'Iceland', 'jetpack-forms' ),
	IN: __( 'India', 'jetpack-forms' ),
	ID: __( 'Indonesia', 'jetpack-forms' ),
	IR: __( 'Iran', 'jetpack-forms' ),
	IQ: __( 'Iraq', 'jetpack-forms' ),
	IE: __( 'Ireland', 'jetpack-forms' ),
	IM: __( 'Isle of Man', 'jetpack-forms' ),
	IL: __( 'Israel', 'jetpack-forms' ),
	IT: __( 'Italy', 'jetpack-forms' ),
	JM: __( 'Jamaica', 'jetpack-forms' ),
	JP: __( 'Japan', 'jetpack-forms' ),
	JE: __( 'Jersey', 'jetpack-forms' ),
	JO: __( 'Jordan', 'jetpack-forms' ),
	KZ: __( 'Kazakhstan', 'jetpack-forms' ),
	KE: __( 'Kenya', 'jetpack-forms' ),
	KI: __( 'Kiribati', 'jetpack-forms' ),
	XK: __( 'Kosovo', 'jetpack-forms' ),
	KW: __( 'Kuwait', 'jetpack-forms' ),
	KG: __( 'Kyrgyzstan', 'jetpack-forms' ),
	LA: __( 'Laos', 'jetpack-forms' ),
	LV: __( 'Latvia', 'jetpack-forms' ),
	LB: __( 'Lebanon', 'jetpack-forms' ),
	LS: __( 'Lesotho', 'jetpack-forms' ),
	LR: __( 'Liberia', 'jetpack-forms' ),
	LY: __( 'Libya', 'jetpack-forms' ),
	LI: __( 'Liechtenstein', 'jetpack-forms' ),
	LT: __( 'Lithuania', 'jetpack-forms' ),
	LU: __( 'Luxembourg', 'jetpack-forms' ),
	MO: __( 'Macao', 'jetpack-forms' ),
	MG: __( 'Madagascar', 'jetpack-forms' ),
	MW: __( 'Malawi', 'jetpack-forms' ),
	MY: __( 'Malaysia', 'jetpack-forms' ),
	MV: __( 'Maldives', 'jetpack-forms' ),
	ML: __( 'Mali', 'jetpack-forms' ),
	MT: __( 'Malta', 'jetpack-forms' ),
	MH: __( 'Marshall Islands', 'jetpack-forms' ),
	MQ: __( 'Martinique', 'jetpack-forms' ),
	MR: __( 'Mauritania', 'jetpack-forms' ),
	MU: __( 'Mauritius', 'jetpack-forms' ),
	YT: __( 'Mayotte', 'jetpack-forms' ),
	MX: __( 'Mexico', 'jetpack-forms' ),
	FM: __( 'Micronesia', 'jetpack-forms' ),
	MD: __( 'Moldova', 'jetpack-forms' ),
	MC: __( 'Monaco', 'jetpack-forms' ),
	MN: __( 'Mongolia', 'jetpack-forms' ),
	ME: __( 'Montenegro', 'jetpack-forms' ),
	MS: __( 'Montserrat', 'jetpack-forms' ),
	MA: __( 'Morocco', 'jetpack-forms' ),
	MZ: __( 'Mozambique', 'jetpack-forms' ),
	MM: __( 'Myanmar', 'jetpack-forms' ),
	NA: __( 'Namibia', 'jetpack-forms' ),
	NR: __( 'Nauru', 'jetpack-forms' ),
	NP: __( 'Nepal', 'jetpack-forms' ),
	NL: __( 'Netherlands', 'jetpack-forms' ),
	NC: __( 'New Caledonia', 'jetpack-forms' ),
	NZ: __( 'New Zealand', 'jetpack-forms' ),
	NI: __( 'Nicaragua', 'jetpack-forms' ),
	NE: __( 'Niger', 'jetpack-forms' ),
	NG: __( 'Nigeria', 'jetpack-forms' ),
	NU: __( 'Niue', 'jetpack-forms' ),
	NF: __( 'Norfolk Island', 'jetpack-forms' ),
	KP: __( 'North Korea', 'jetpack-forms' ),
	MK: __( 'North Macedonia', 'jetpack-forms' ),
	MP: __( 'Northern Mariana Islands', 'jetpack-forms' ),
	NO: __( 'Norway', 'jetpack-forms' ),
	OM: __( 'Oman', 'jetpack-forms' ),
	PK: __( 'Pakistan', 'jetpack-forms' ),
	PW: __( 'Palau', 'jetpack-forms' ),
	PS: __( 'Palestine', 'jetpack-forms' ),
	PA: __( 'Panama', 'jetpack-forms' ),
	PG: __( 'Papua New Guinea', 'jetpack-forms' ),
	PY: __( 'Paraguay', 'jetpack-forms' ),
	PE: __( 'Peru', 'jetpack-forms' ),
	PH: __( 'Philippines', 'jetpack-forms' ),
	PN: __( 'Pitcairn Islands', 'jetpack-forms' ),
	PL: __( 'Poland', 'jetpack-forms' ),
	PT: __( 'Portugal', 'jetpack-forms' ),
	PR: __( 'Puerto Rico', 'jetpack-forms' ),
	QA: __( 'Qatar', 'jetpack-forms' ),
	RO: __( 'Romania', 'jetpack-forms' ),
	RU: __( 'Russia', 'jetpack-forms' ),
	RW: __( 'Rwanda', 'jetpack-forms' ),
	RE: __( 'Réunion', 'jetpack-forms' ),
	BL: __( 'Saint Barthélemy', 'jetpack-forms' ),
	SH: __( 'Saint Helena', 'jetpack-forms' ),
	KN: __( 'Saint Kitts and Nevis', 'jetpack-forms' ),
	LC: __( 'Saint Lucia', 'jetpack-forms' ),
	MF: __( 'Saint Martin', 'jetpack-forms' ),
	PM: __( 'Saint Pierre and Miquelon', 'jetpack-forms' ),
	VC: __( 'Saint Vincent and the Grenadines', 'jetpack-forms' ),
	WS: __( 'Samoa', 'jetpack-forms' ),
	SM: __( 'San Marino', 'jetpack-forms' ),
	SA: __( 'Saudi Arabia', 'jetpack-forms' ),
	SN: __( 'Senegal', 'jetpack-forms' ),
	RS: __( 'Serbia', 'jetpack-forms' ),
	SC: __( 'Seychelles', 'jetpack-forms' ),
	SL: __( 'Sierra Leone', 'jetpack-forms' ),
	SG: __( 'Singapore', 'jetpack-forms' ),
	SK: __( 'Slovakia', 'jetpack-forms' ),
	SI: __( 'Slovenia', 'jetpack-forms' ),
	SB: __( 'Solomon Islands', 'jetpack-forms' ),
	SO: __( 'Somalia', 'jetpack-forms' ),
	ZA: __( 'South Africa', 'jetpack-forms' ),
	GS: __( 'South Georgia and the South Sandwich Islands', 'jetpack-forms' ),
	KR: __( 'South Korea', 'jetpack-forms' ),
	ES: __( 'Spain', 'jetpack-forms' ),
	LK: __( 'Sri Lanka', 'jetpack-forms' ),
	SD: __( 'Sudan', 'jetpack-forms' ),
	SR: __( 'Suriname', 'jetpack-forms' ),
	SJ: __( 'Svalbard and Jan Mayen', 'jetpack-forms' ),
	SE: __( 'Sweden', 'jetpack-forms' ),
	CH: __( 'Switzerland', 'jetpack-forms' ),
	SY: __( 'Syria', 'jetpack-forms' ),
	ST: __( 'São Tomé and Príncipe', 'jetpack-forms' ),
	TW: __( 'Taiwan', 'jetpack-forms' ),
	TJ: __( 'Tajikistan', 'jetpack-forms' ),
	TZ: __( 'Tanzania', 'jetpack-forms' ),
	TH: __( 'Thailand', 'jetpack-forms' ),
	TL: __( 'Timor-Leste', 'jetpack-forms' ),
	TG: __( 'Togo', 'jetpack-forms' ),
	TK: __( 'Tokelau', 'jetpack-forms' ),
	TO: __( 'Tonga', 'jetpack-forms' ),
	TT: __( 'Trinidad and Tobago', 'jetpack-forms' ),
	TN: __( 'Tunisia', 'jetpack-forms' ),
	TR: __( 'Turkey', 'jetpack-forms' ),
	TM: __( 'Turkmenistan', 'jetpack-forms' ),
	TC: __( 'Turks and Caicos Islands', 'jetpack-forms' ),
	TV: __( 'Tuvalu', 'jetpack-forms' ),
	VI: __( 'U.S. Virgin Islands', 'jetpack-forms' ),
	UG: __( 'Uganda', 'jetpack-forms' ),
	UA: __( 'Ukraine', 'jetpack-forms' ),
	AE: __( 'United Arab Emirates', 'jetpack-forms' ),
	GB: __( 'United Kingdom', 'jetpack-forms' ),
	US: __( 'United States', 'jetpack-forms' ),
	UY: __( 'Uruguay', 'jetpack-forms' ),
	UZ: __( 'Uzbekistan', 'jetpack-forms' ),
	VU: __( 'Vanuatu', 'jetpack-forms' ),
	VA: __( 'Vatican City', 'jetpack-forms' ),
	VE: __( 'Venezuela', 'jetpack-forms' ),
	VN: __( 'Vietnam', 'jetpack-forms' ),
	WF: __( 'Wallis and Futuna', 'jetpack-forms' ),
	YE: __( 'Yemen', 'jetpack-forms' ),
	ZM: __( 'Zambia', 'jetpack-forms' ),
	ZW: __( 'Zimbabwe', 'jetpack-forms' ),
};

/**
 * Helper function to get translated country name by country code
 * @param {string} countryCode - Two-letter country code (e.g., 'US', 'CA')
 * @return {string} Translated country name or the original code if not found
 */
export const getTranslatedCountryName = countryCode => {
	return translatedCountryNames[ countryCode ] || countryCode;
};
