import { SVG, Path, Circle, SVGProps } from '@wordpress/primitives';

const SalesforceCircleIcon = ( props: SVGProps & { width?: number; height?: number } ) => (
	<SVG
		width={ props.width || 32 }
		height={ props.height || 32 }
		viewBox="0 0 28 28"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		role="img"
		{ ...props }
	>
		<Circle cx="14" cy="14" r="14" fill="#F6F7F7" />
		<g clipPath="url(#clip0_4650_8281)">
			<Path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M11.9653 7.44496C12.74 6.63849 13.8182 6.13908 15.0094 6.13908C16.5976 6.13908 17.9741 7.02143 18.7153 8.33614C19.3732 8.04203 20.0858 7.89019 20.8065 7.89055C23.6653 7.89055 25.9859 10.2288 25.9859 13.1141C25.9859 15.9994 23.6653 18.3376 20.8065 18.3376C20.457 18.3376 20.1165 18.3025 19.7829 18.2361C19.1344 19.392 17.8947 20.1773 16.4829 20.1773C15.9081 20.1785 15.3407 20.0481 14.8241 19.7961C14.1667 21.3403 12.6359 22.4256 10.8535 22.4256C8.99175 22.4256 7.41233 21.252 6.80351 19.602C6.53254 19.6592 6.25634 19.688 5.97939 19.6878C3.76469 19.6878 1.97351 17.8701 1.97351 15.6378C1.97351 14.1378 2.77998 12.8319 3.97645 12.126C3.72262 11.5413 3.59196 10.9105 3.59263 10.2731C3.59263 7.69661 5.6838 5.61426 8.26028 5.61426C9.7691 5.61426 11.1191 6.33338 11.9662 7.44955"
				fill="#00A1E0"
			/>
			<Path
				d="M15.9801 11.4786C16.0433 11.4779 16.1063 11.4828 16.1686 11.4932C16.215 11.5013 16.2612 11.5118 16.3063 11.5255C16.3162 11.5293 16.3436 11.5429 16.3326 11.5743L16.2262 11.8663C16.2173 11.8882 16.2108 11.9015 16.1657 11.8878C16.1544 11.8844 16.1374 11.8793 16.0944 11.8702C16.0631 11.8637 16.0219 11.8585 15.9801 11.8585C15.9296 11.8578 15.879 11.8651 15.8307 11.8799C15.7866 11.8944 15.746 11.92 15.7135 11.9532C15.6788 11.988 15.6376 12.0389 15.6159 12.1016C15.565 12.2484 15.5449 12.4042 15.5426 12.4151H15.9879C16.025 12.415 16.0365 12.4323 16.0328 12.46L15.9811 12.7491C15.9731 12.791 15.9342 12.7901 15.9342 12.7901H15.4762L15.1627 14.5645C15.1298 14.7479 15.0889 14.9055 15.0407 15.0323C14.9919 15.1601 14.9401 15.2533 14.859 15.3428C14.784 15.4258 14.6996 15.4873 14.6022 15.5225C14.5054 15.5575 14.3885 15.5753 14.2604 15.5753C14.1993 15.5753 14.1337 15.5749 14.0563 15.5567C14.0007 15.5436 13.9702 15.5342 13.9293 15.5196C13.9119 15.5133 13.8982 15.4913 13.9078 15.4639C13.9175 15.436 13.9998 15.2103 14.0114 15.1807C14.0247 15.147 14.0571 15.1569 14.0612 15.1583C14.0859 15.1686 14.1035 15.1762 14.1364 15.1827C14.1694 15.1893 14.215 15.1954 14.2487 15.1954C14.309 15.1953 14.3639 15.187 14.4117 15.171C14.4699 15.1515 14.5041 15.1187 14.5397 15.0733C14.5764 15.0264 14.6058 14.9614 14.6364 14.8751C14.6673 14.7877 14.6959 14.6725 14.7203 14.5323L15.0319 12.7901H14.7242C14.6873 12.7902 14.6757 12.7728 14.6793 12.7452L14.7311 12.4561C14.7392 12.414 14.778 12.4151 14.778 12.4151H15.0934L15.111 12.3213C15.1582 12.0419 15.2519 11.8289 15.3903 11.6895C15.5296 11.5491 15.7284 11.4786 15.9801 11.4786ZM6.34437 12.3663C6.60904 12.3663 6.86515 12.4428 7.05042 12.5557C7.06719 12.5658 7.08317 12.5857 7.07386 12.6114C7.06434 12.6379 6.9827 12.856 6.97327 12.8809C6.95589 12.9271 6.90784 12.8965 6.90784 12.8965C6.7464 12.8074 6.49448 12.7364 6.28284 12.7364C6.09228 12.7364 5.96842 12.838 5.96839 12.9756V12.9835C5.96839 13.144 6.17918 13.2138 6.42347 13.293L6.46644 13.3067C6.78916 13.4081 7.13513 13.55 7.13538 13.9395V13.9483C7.13535 14.37 6.82881 14.6319 6.33655 14.6319C6.09479 14.6319 5.8631 14.5936 5.6178 14.4639C5.57209 14.4375 5.52601 14.4144 5.48109 14.3819C5.47624 14.3749 5.45632 14.3665 5.47132 14.3272V14.3262L5.568 14.0567C5.58332 14.0106 5.61828 14.0257 5.63245 14.0342C5.65911 14.0505 5.67903 14.0649 5.71351 14.085C6.00027 14.2663 6.26524 14.2676 6.34827 14.2676C6.56179 14.2676 6.69495 14.1537 6.69495 14.001V13.9932C6.69495 13.8273 6.49002 13.7642 6.25355 13.6915L6.20179 13.6749C5.8771 13.5822 5.52897 13.4483 5.52894 13.0372V13.0284C5.52913 12.6386 5.84479 12.3663 6.29554 12.3663H6.34437ZM13.5524 12.3653C13.817 12.3653 14.0732 12.4418 14.2584 12.5547C14.2751 12.5648 14.2913 12.5846 14.2819 12.6104C14.2738 12.6355 14.1922 12.8534 14.1823 12.8799C14.1648 12.9261 14.1168 12.8956 14.1168 12.8956C13.9546 12.8065 13.7035 12.7355 13.4918 12.7354C13.3014 12.7354 13.1776 12.8372 13.1774 12.9747V12.9835C13.1776 13.1439 13.3882 13.2129 13.6325 13.2921L13.6744 13.3057C13.9983 13.4072 14.3434 13.5495 14.3434 13.9395V13.9473C14.3434 14.369 14.0376 14.6308 13.5455 14.6309C13.3038 14.6309 13.0721 14.5936 12.8268 14.4639C12.7809 14.4374 12.735 14.4136 12.6901 14.3809C12.685 14.374 12.6643 14.3656 12.6793 14.3262L12.6784 14.3253L12.776 14.0557C12.7902 14.0116 12.8315 14.0276 12.8405 14.0333C12.8667 14.0502 12.887 14.0639 12.9215 14.084C13.2074 14.2653 13.4731 14.2667 13.5563 14.2667C13.7695 14.2666 13.9027 14.1534 13.903 14.001V13.9922C13.9029 13.8264 13.6989 13.7632 13.4616 13.6905L13.4098 13.6739C13.0851 13.5812 12.7369 13.4474 12.7369 13.0362V13.0284C12.7369 12.6385 13.0519 12.3655 13.5026 12.3653H13.5524ZM17.069 12.3731C17.2366 12.3731 17.3851 12.4023 17.5104 12.461C17.6365 12.5192 17.7419 12.6007 17.8258 12.7012C17.9096 12.8018 17.9728 12.9219 18.0133 13.0587H18.0123C18.0524 13.1945 18.0729 13.344 18.0729 13.501C18.0728 13.6587 18.0523 13.8067 18.0123 13.9424C17.9718 14.0791 17.9094 14.1993 17.8258 14.2999C17.742 14.4005 17.6347 14.481 17.5094 14.5381C17.3841 14.5953 17.2357 14.6241 17.069 14.6241C16.9023 14.6241 16.7537 14.5953 16.6276 14.5381C16.5025 14.4808 16.396 14.4003 16.3121 14.2999C16.2284 14.1993 16.165 14.0792 16.1246 13.9424C16.0846 13.8068 16.0641 13.6587 16.0641 13.501C16.0641 13.3432 16.0845 13.1945 16.1246 13.0587C16.1652 12.9219 16.2285 12.8018 16.3121 12.7012C16.3959 12.6007 16.5024 12.5196 16.6276 12.461C16.7537 12.4025 16.9014 12.3731 17.069 12.3731ZM11.5104 12.3712C11.6474 12.3709 11.7837 12.3986 11.9098 12.4522C11.9971 12.4893 12.0845 12.5573 12.1744 12.6534C12.2309 12.7143 12.3172 12.8481 12.3522 12.9796H12.3532C12.4419 13.2906 12.3972 13.56 12.3951 13.5782C12.3914 13.614 12.3541 13.6143 12.3541 13.6143L10.9606 13.6133C10.9685 13.8251 11.0194 13.9749 11.1217 14.0772C11.2223 14.1771 11.3831 14.2409 11.5983 14.2413C11.9292 14.2422 12.0708 14.175 12.1705 14.1378C12.1742 14.1366 12.209 14.1261 12.2223 14.1622L12.3131 14.4171C12.3314 14.46 12.3168 14.4748 12.3014 14.4835C12.2147 14.532 12.0031 14.6218 11.6012 14.6231C11.4053 14.6237 11.2356 14.5953 11.0953 14.5411C10.9543 14.4864 10.8374 14.4083 10.7457 14.3087C10.6549 14.2098 10.5867 14.091 10.5446 13.9551C10.5025 13.8202 10.4811 13.6713 10.4811 13.5108C10.4811 13.3537 10.5011 13.2032 10.5416 13.0665C10.5822 12.928 10.6467 12.8074 10.7311 12.7051C10.8158 12.6028 10.9235 12.5212 11.0514 12.461C11.1792 12.4013 11.3368 12.3712 11.5104 12.3712ZM22.6549 12.3712C22.7918 12.3709 22.9274 12.3987 23.0534 12.4522C23.1406 12.4892 23.2281 12.5574 23.318 12.6534C23.3745 12.7143 23.4617 12.8481 23.4967 12.9796H23.4987C23.5873 13.2908 23.5417 13.5604 23.5397 13.5782C23.536 13.6128 23.502 13.6143 23.4996 13.6143L22.1051 13.6133C22.1131 13.8251 22.1649 13.9749 22.2672 14.0772C22.3678 14.177 22.5278 14.2409 22.7438 14.2413C23.0743 14.2421 23.2154 14.175 23.3151 14.1378C23.3151 14.1378 23.3539 14.1241 23.3678 14.1622L23.4586 14.4171C23.4766 14.4597 23.4622 14.4748 23.4469 14.4835C23.3604 14.532 23.1481 14.6218 22.7457 14.6231C22.551 14.6237 22.381 14.5952 22.2409 14.5411C22.0997 14.4864 21.982 14.4084 21.8903 14.3087C21.7986 14.2099 21.7304 14.0909 21.6881 13.9551C21.6463 13.8202 21.6247 13.6713 21.6246 13.5108C21.6246 13.3537 21.6456 13.2032 21.6862 13.0665C21.7267 12.9282 21.7902 12.8074 21.8746 12.7051C21.9593 12.6029 22.0671 12.5212 22.195 12.461C22.3229 12.4013 22.4811 12.3712 22.6549 12.3712ZM20.8659 12.3672C20.9822 12.3673 21.0854 12.3742 21.1744 12.3878C21.2697 12.4022 21.3956 12.4363 21.4489 12.4571C21.4587 12.4609 21.4851 12.4747 21.4742 12.5059C21.4356 12.6151 21.4087 12.6866 21.3727 12.7862C21.3572 12.8285 21.3248 12.8145 21.3248 12.8145C21.1891 12.7721 21.0595 12.752 20.8903 12.752C20.6875 12.752 20.5339 12.821 20.4342 12.9532C20.3332 13.0873 20.2766 13.2623 20.276 13.4952C20.2751 13.7511 20.3389 13.9403 20.4528 14.0577C20.5656 14.1747 20.7243 14.2334 20.9225 14.2335C21.0028 14.2335 21.0796 14.2286 21.1481 14.2178C21.216 14.2072 21.2798 14.186 21.3395 14.1631C21.3411 14.1626 21.3616 14.1553 21.3776 14.1671L21.3922 14.1876L21.4938 14.4669C21.5059 14.4997 21.4798 14.5143 21.4772 14.5157C21.3219 14.5772 21.1051 14.6202 20.8942 14.6202C20.5379 14.6201 20.2643 14.5174 20.0826 14.3145C19.901 14.1126 19.8093 13.8365 19.8092 13.4962C19.8092 13.3382 19.832 13.1887 19.8766 13.0528C19.9216 12.916 19.9886 12.796 20.0768 12.6954C20.165 12.5948 20.2764 12.5136 20.4078 12.4551C20.5392 12.3967 20.6931 12.3672 20.8659 12.3672ZM8.32581 12.3682C8.60357 12.3683 8.81808 12.4327 8.96448 12.5606C9.11141 12.6886 9.18616 12.8961 9.18616 13.1749V14.4454C9.18616 14.4454 9.18927 14.4825 9.15491 14.4913C9.15491 14.4913 9.10357 14.505 9.05726 14.5157C8.94102 14.5409 8.82388 14.5638 8.70667 14.584C8.56902 14.6073 8.42676 14.6192 8.28382 14.6192C8.14796 14.6192 8.02408 14.6061 7.91468 14.5811C7.80455 14.5564 7.70876 14.5153 7.63148 14.459C7.55371 14.4027 7.49133 14.3269 7.44984 14.2403C7.40762 14.153 7.38636 14.0462 7.38636 13.9229C7.38638 13.8012 7.41128 13.6933 7.46058 13.6016C7.50944 13.5107 7.57872 13.4321 7.66273 13.3721C7.74645 13.3119 7.8444 13.2666 7.95277 13.2374C8.06041 13.2082 8.17642 13.1934 8.29554 13.1934C8.38275 13.1934 8.45591 13.1951 8.51234 13.1993L8.51429 13.2032C8.5223 13.2039 8.62841 13.2139 8.7428 13.2305V13.171C8.74274 12.9861 8.70436 12.8982 8.62855 12.8399C8.55097 12.7804 8.43461 12.7501 8.2848 12.7501C8.2848 12.7501 7.94568 12.7452 7.67835 12.8907C7.666 12.898 7.65491 12.9024 7.65491 12.9024C7.6509 12.9036 7.6215 12.9115 7.60999 12.8799L7.51038 12.6153C7.49612 12.5788 7.52067 12.5612 7.52308 12.5596C7.64588 12.4635 7.94015 12.4047 7.95179 12.4024C8.05238 12.3822 8.22169 12.3682 8.32581 12.3682ZM10.0485 11.5225C10.0717 11.5226 10.0885 11.5423 10.0885 11.5655V14.5362C10.0883 14.5592 10.0716 14.5781 10.0485 14.5782H9.67933C9.65611 14.5782 9.63952 14.5593 9.63929 14.5362V11.5655C9.63929 11.5423 9.65595 11.5225 9.67933 11.5225H10.0485ZM19.4645 12.3926C19.5554 12.3983 19.6741 12.4237 19.6979 12.4327C19.7024 12.4345 19.7071 12.4371 19.7106 12.4405C19.7141 12.444 19.7165 12.4486 19.7184 12.4532C19.7203 12.4578 19.7213 12.4628 19.7213 12.4678L19.7194 12.4766C19.7061 12.5146 19.6378 12.705 19.6139 12.7686C19.6048 12.7928 19.5899 12.8097 19.5631 12.8067C19.5585 12.8056 19.4814 12.7872 19.4108 12.7872C19.3475 12.7872 19.2841 12.7961 19.2233 12.8135C19.1586 12.8337 19.0996 12.8694 19.0514 12.9171C19.0009 12.9665 18.9605 13.0358 18.9303 13.1221C18.8997 13.2095 18.8844 13.348 18.8844 13.4874V14.5284C18.8844 14.5394 18.8794 14.5498 18.8717 14.5577C18.8638 14.5656 18.8526 14.5703 18.8414 14.5704H18.4762C18.4651 14.5703 18.4548 14.5655 18.4469 14.5577C18.4391 14.5498 18.4343 14.5395 18.4342 14.5284V12.4551C18.4342 12.4318 18.4511 12.4131 18.4742 12.4131H18.8307C18.8541 12.4132 18.8707 12.4319 18.8707 12.4551V12.6241C18.9236 12.5518 19.0189 12.4892 19.1051 12.4503C19.1925 12.4111 19.2898 12.3817 19.4645 12.3926ZM8.36487 13.546C8.08182 13.5424 7.96061 13.6459 7.96058 13.6465C7.87683 13.7057 7.83655 13.7944 7.83655 13.9161C7.8366 13.9935 7.85098 14.0542 7.87855 14.0967C7.89648 14.1248 7.90425 14.1354 7.95862 14.1788L7.9596 14.1797C7.96686 14.1856 8.09297 14.2773 8.36683 14.2608C8.46651 14.2548 8.56049 14.2425 8.62952 14.2315L8.7428 14.211V13.5782C8.61779 13.559 8.49134 13.5482 8.36487 13.546ZM17.6022 13.501C17.6022 13.2628 17.5579 13.0749 17.4703 12.9434C17.3839 12.8138 17.2533 12.751 17.07 12.751C16.8867 12.7511 16.7569 12.8131 16.6715 12.9434C16.5856 13.0749 16.5416 13.2628 16.5416 13.501C16.5417 13.739 16.5854 13.9274 16.6715 14.0596C16.7571 14.1907 16.8874 14.2549 17.07 14.2549C17.2524 14.2549 17.3835 14.1908 17.4703 14.0596C17.5572 13.9266 17.602 13.7387 17.6022 13.501ZM22.6227 12.7403C22.44 12.7403 22.3096 12.8119 22.2242 12.9424C22.1673 13.028 22.1306 13.1383 22.111 13.2706H23.1041C23.0948 13.1428 23.0695 13.0284 23.0123 12.9424C22.9259 12.8123 22.8051 12.7404 22.6227 12.7403ZM11.4782 12.7403C11.2955 12.7403 11.1651 12.8119 11.0797 12.9424C11.023 13.028 10.9871 13.1384 10.9674 13.2706H11.9596C11.9502 13.1427 11.925 13.0285 11.8678 12.9424C11.7813 12.8122 11.6608 12.7403 11.4782 12.7403Z"
				fill="#FFFFFE"
			/>
		</g>
		<defs>
			<clipPath id="clip0_4650_8281">
				<rect width="24" height="24" fill="white" transform="translate(2 2)" />
			</clipPath>
		</defs>
	</SVG>
);

export default SalesforceCircleIcon;
